   pro rdquerry_minerals,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='querry_minerals.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idnclay=ncdf_varid(nc_id,'nclay')
  idnillite=ncdf_varid(nc_id,'nillite')
  idnkaolin=ncdf_varid(nc_id,'nkaolin')
  idnmont=ncdf_varid(nc_id,'nmont')

  idwcmclay=ncdf_varid(nc_id,'wcmclay')
  idwcmillite=ncdf_varid(nc_id,'wcmillite')
  idwcmkaolin=ncdf_varid(nc_id,'wcmkaolin')
  idwcmmont=ncdf_varid(nc_id,'wcmmont')

  idwmicclay=ncdf_varid(nc_id,'wmicclay')
  idwmicillite=ncdf_varid(nc_id,'wmicillite')
  idwmickaolin=ncdf_varid(nc_id,'wmickaolin')
  idwmicmont=ncdf_varid(nc_id,'wmicmont')

  idrnclay=ncdf_varid(nc_id,'rnclay')
  idrnillite=ncdf_varid(nc_id,'rnillite')
  idrnkaolin=ncdf_varid(nc_id,'rnkaolin')
  idrnmont=ncdf_varid(nc_id,'rnmont')

  idriclay=ncdf_varid(nc_id,'riclay')
  idriillite=ncdf_varid(nc_id,'riillite')
  idrikaolin=ncdf_varid(nc_id,'rikaolin')
  idrimont=ncdf_varid(nc_id,'rimont')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70

  ncdf_varget,nc_id,idnclay,nclay
  ncdf_varget,nc_id,idnillite,nillite
  ncdf_varget,nc_id,idnkaolin,nkaolin
  ncdf_varget,nc_id,idnmont,nmont

  ncdf_varget,nc_id,idwcmclay,wcmclay
  ncdf_varget,nc_id,idwcmillite,wcmillite
  ncdf_varget,nc_id,idwcmkaolin,wcmkaolin
  ncdf_varget,nc_id,idwcmmont,wcmmont

  ncdf_varget,nc_id,idwmicclay,wmicclay
  ncdf_varget,nc_id,idwmicillite,wmicillite
  ncdf_varget,nc_id,idwmickaolin,wmickaolin
  ncdf_varget,nc_id,idwmicmont,wmicmont

  ncdf_varget,nc_id,idrnclay,rnclay
  ncdf_varget,nc_id,idrnillite,rnillite
  ncdf_varget,nc_id,idrnkaolin,rnkaolin
  ncdf_varget,nc_id,idrnmont,rnmont

  ncdf_varget,nc_id,idriclay,riclay
  ncdf_varget,nc_id,idriillite,riillite
  ncdf_varget,nc_id,idrikaolin,rikaolin
  ncdf_varget,nc_id,idrimont,rimont

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Specify which set to work with
  print,'  Querry minerals '
  print,'  iset=0,1,2,3 for clay, illite, kaolin, montmorillonite'
  print,'  Specify iset'

  read,iset

  lines2=intarr(8)
  lines2(0)=nclay
  lines2(1)=nillite
  lines2(2)=nkaolin
  lines2(3)=nmont

  nlines=intarr(1)
  nlines=lines2(iset)
  i1=0
  i2=nlines(0)-1
  nlines=i2+1

  rndat=fltarr(nlines)
  ridat=fltarr(nlines)
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)

; **
  if (iset eq 0) then begin
   for i=i1,i2 do begin
    rndat(i)=rnclay(i)
    ridat(i)=riclay(i)
    wcm(i)=wcmclay(i)
    wavelength(i)=wmicclay(i)
   endfor
   casestr=' clay '
   goto,jump1
  endif

  if (iset eq 1) then begin
   for i=i1,i2 do begin
    rndat(i)=rnillite(i)
    ridat(i)=riillite(i)
    wcm(i)=wcmillite(i)
    wavelength(i)=wmicillite(i)
   endfor
   casestr=' illite '
   goto,jump1
  endif

  if (iset eq 2) then begin
   for i=i1,i2 do begin
    rndat(i)=rnkaolin(i)
    ridat(i)=rikaolin(i)
    wcm(i)=wcmkaolin(i)
    wavelength(i)=wmickaolin(i)
   endfor
   casestr=' kaolin'
   goto,jump1
  endif

  if (iset eq 3) then begin
   for i=i1,i2 do begin
    rndat(i)=rnmont(i)
    ridat(i)=rimont(i)
    wcm(i)=wcmmont(i)
    wavelength(i)=wmicmont(i)
   endfor
   casestr=' mont '
   goto,jump1
  endif

  jump1:mn=0

; ***
   lset=strcompress(lstrn+casestr)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdquerry_minerals: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdquerry_minerals: i,wcm,wavelength,rndat and ridat'
   for i=i1,i2 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


