   pro rdremsberg_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='remsberg_h2so4_hno3.nc'
  filnm=strcompress(indir+fil)
  
; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idnh2so475=ncdf_varid(nc_id,'nh2so475')
  idnh2so490=ncdf_varid(nc_id,'nh2so490')
  idnhno368=ncdf_varid(nc_id,'nhno368')

  idwcmh2so475=ncdf_varid(nc_id,'wcmh2so475')
  idwcmh2so490=ncdf_varid(nc_id,'wcmh2so490')
  idwcmhno368=ncdf_varid(nc_id,'wcmhno368')

  idwmich2so475=ncdf_varid(nc_id,'wmich2so475')
  idwmich2so490=ncdf_varid(nc_id,'wmich2so490')
  idwmichno368=ncdf_varid(nc_id,'wmichno368')

  idrnh2so475=ncdf_varid(nc_id,'rnh2so475')
  idrih2so475=ncdf_varid(nc_id,'rih2so475')

  idrnh2so490=ncdf_varid(nc_id,'rnh2so490')
  idrih2so490=ncdf_varid(nc_id,'rih2so490')

  idrnhno368=ncdf_varid(nc_id,'rnhno368')
  idrihno368=ncdf_varid(nc_id,'rihno368')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70

  ncdf_varget,nc_id,idnh2so475,nh2so475
  ncdf_varget,nc_id,idnh2so490,nh2so490
  ncdf_varget,nc_id,idnhno368,nhno368

  ncdf_varget,nc_id,idwmich2so475,wmich2so475
  ncdf_varget,nc_id,idwmich2so490,wmich2so490
  ncdf_varget,nc_id,idwmichno368,wmichno368

  ncdf_varget,nc_id,idwcmh2so475,wcmh2so475
  ncdf_varget,nc_id,idwcmh2so490,wcmh2so490
  ncdf_varget,nc_id,idwcmhno368,wcmhno368

  ncdf_varget,nc_id,idrnh2so475,rnh2so475
  ncdf_varget,nc_id,idrnh2so490,rnh2so490
  ncdf_varget,nc_id,idrnhno368,rnhno368

  ncdf_varget,nc_id,idrih2so475,rih2so475
  ncdf_varget,nc_id,idrih2so490,rih2so490
  ncdf_varget,nc_id,idrihno368,rihno368

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  remsberg hno3 and h2so4 binary'
  print,'  icase 0=75% H2SO4, 1=90% H2SO4, and 2=68% HNO3'
  print,'  specify icase 0,1,2 '
  read,icase

; *****
   casestr=strarr(1)
  if (icase eq 0) then begin
   nlines=nh2so475
   casestr='75% H2SO4'
  endif
  if (icase eq 1) then begin
   nlines=nh2so490
   casestr='90% H2SO4'
  endif
  if (icase eq 2) then begin
   nlines=nhno368
   casestr='68% HNO3'
  endif

; ***
   lset=strcompress(lstrn+'   '+casestr)

    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)
   for i=0,nlines-1 do begin
    if (icase eq 0) then begin
     rndat(i)=rnh2so475(i)
     ridat(i)=rih2so475(i)
     wcm(i)=wcmh2so475(i)
     wavelength(i)=wmich2so475(i)
    endif
    if (icase eq 1) then begin
     rndat(i)=rnh2so490(i)
     ridat(i)=rih2so490(i)
     wcm(i)=wcmh2so490(i)
     wavelength(i)=wmich2so490(i)
    endif
    if (icase eq 2) then begin
     rndat(i)=rnhno368(i)
     ridat(i)=rihno368(i)
     wcm(i)=wcmhno368(i)
     wavelength(i)=wmichno368(i)
    endif
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdremsberg_hno3: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  remsberg_hno3: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


